;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(lib "reader.ss" "plai" "lang")
;; Cada Variable de tipo que usemos en los sgtes contratos
;; viene excplicado en esta secci'on de comentarios.
;; k = llave
;; v = valor
;; i = valor intermedio, producido por la funci'on m
;; u = valor de reduci'on de valores intermedios, producido por la funci'on r


;; map-reduce :: (pair-of(v,list-of(i)) -> u)
;;             x (pair-of(k,list-of(v)) -> list-of-pair(v,i))
;;             x  list-of-pair(k,list-of(v)) -> list-of-pair(v,u)
;; La funci'on map-reduce, compuesta por tres etapas: "mapear", agrupar y reducir
(define map-reduce (lambda (r m pairs) 
                     (reduce- r (group (map- m pairs)))))



;;map- :: (pair-of(k,list-of(v)) -> list-of-pair(v,i))
;;      x  list-of-pair(k,list-of(v)) -> list-of-pair(v,i)
;; Recibe la funci'on m (del usuario) para aplicar el map a cada (key, values)
;; kv, representa el par (llave, valores)
(define map-
  (lambda (m pairs) 
    (foldl (lambda (kv ls) (append ls (m kv))) empty pairs)))

;; m1 :: pair-of(k,list-of(v)) -> list-of-pair(v,number)
;; Es una instancia de m, para el ejemplo del enunciado
(define m1 (lambda (kv) (map (lambda (x) (list x 1)) (second kv))))

;; ex1 :: list-of-pair(symbol,list-of(string))
;; Expresi'on para testeo de la funci'on map-reduce
(define ex1 '((doc1 ("a" "b" "c")) (doc2 ("c" "a" "a"))))

;; Valida si m1 funciona, con datos del ejemplo
(test (m1 '(doc1 ("a" "b" "c"))) '(("a" 1)("b" 1)("c" 1)))

;; Veridica si el map (componente del map-reduce) funciona adecuadamente
(test (map- m1 ex1) (list (list "a" 1) (list "b" 1) (list "c" 1)
                          (list "c" 1) (list "a" 1) (list "a" 1)))


;; group :: list-of-pair(v,i) -> list-of-pair(v,list-of(i))]
;; Agrupa todas las llaves intermedias, funci'on usada por mapReduce
;; inter, representa un valor intermedio
(define group
  (lambda (pairs) 
    (if (empty? pairs) empty
        (let ((value (first (first pairs))) 
              (inter (second (first pairs))))
          (cons (list value (groupby value inter (rest pairs)))
                (group (filter (lambda (pair) (not (string=? value (first pair)))) 
                           (rest pairs))))))))

;; groupby :: v x i x list-of-pair(v,i) -> list-of(i)
;; Funci'on auxiliar de apoyo a group
(define groupby
  (lambda (value inter ls)
    (if (empty? ls) (list inter)
        (let ((other (first (first ls))) 
              (interr (second (first ls))))
          (if (string=? value other) (cons interr (groupby value inter (rest ls)))
              (groupby value inter (rest ls)))))))


;; Verifica si hace una buena agrupaci'on, seg'un datos del ejemplo
(test (group (map- m1 ex1))
      (list (list "a" (list 1 1 1)) (list "b" (list 1)) (list "c" (list 1 1))))

;; reduce- :: (pair-of(v,list-of(i)) -> u) 
;;          x list-of-pair(v, list-of(i)) -> list-of-pair(v,u)
;; Recibe la funci'on r (del usuario) para aplicar el reduce a cada grupo
(define reduce-
  (lambda (r pairs)
    (map (lambda (pair) (list (first pair) (r pair))) pairs)))


;; r1 :: pair-of(v,list-of(number)) -> number 
;; Es una instancia de r, para el ejemplo del enunciado
(define r1 (lambda (pair) (foldl + 0 (second pair))))

;; Verifica si r1 cumple con su objetivo de reducir
(test (r1 (list "a" (list 1 1 1))) 3)


;; Verifica si map-reduce funciona, con el ejemplo del enunciado
(test (map-reduce r1 m1 ex1) '(("a" 3)("b" 1)("c" 2)))

;; inverted-index :: list-of-pair(k,list-of(v)) 
;;                -> list-of-pair(v,list-of(k)) 
;; Funci'on que retorna el 'indice invertido de la lista (llave, lista de 
;; valores) esta parametrizada por r y m aplicadas al map-reduce.
;; dk, representa el par (doc, llaves)
(define (inverted-index pairs)
  (map-reduce (lambda (xds) 
                (foldl (lambda (doc ls) (if (elem doc ls) ls (cons doc ls))) 
                       empty (second xds))) 
              (lambda (dk) 
                (map (lambda (key) (list key (first dk))) (second dk)))
              pairs))

;; firsts :: list-of-pair(key,list-of(value)) -> list-of(key)
;; Funci'on auxiliar de apoyo a inverted-index.
(define (firsts ls)
  (if (empty? ls) empty
      (cons (first (first ls)) (firsts (rest ls)))))

;; elem :: a x list-of(a) -> Bool 
;; Funci'on auxiliar de apoyo a inverted-index, que verifica
;; si un elemento esta en una lista
(define (elem x xs)
  (cond
    ((empty? xs) #f)
    ((eq? x (first xs)))
    (else (elem x (cdr xs)))))

;; Test que prueba el ejemplo de 'indice invertido del enunciado, usando r y m
(test (inverted-index ex1)
      (list (list "a" (list 'doc1 'doc2))
            (list "b" (list 'doc1))
            (list "c" (list 'doc1 'doc2))))      
